import { StyleSheet } from "react-native";
import React from "react";
import dpr from "../CustomStyleAttribute/dpr";
import StarRating from "react-native-star-rating-widget";

const CustomRating = ({
    rating = 0,
    onChange = null,
    readOnly = false,
    starSize = dpr(22),
    starStyle = {},
    color = "#FCCA19",
    emptyColor = "#C8C8C8",
    enableSwiping = true,
    enableHalfStar = true,
    animationConfig = {},
    style = {},
}) => {
    const styles = Array.isArray(style) ? style : [style];
    const ratingStyle = RatingStyle();
    return (
        <StarRating
            rating={rating}
            onChange={(value) =>
                readOnly
                    ? null
                    : typeof onChange == "function"
                    ? onChange(value)
                    : null
            }
            starSize={starSize}
            starStyle={[ratingStyle.starStyle, starStyle]}
            color={color}
            emptyColor={emptyColor}
            enableSwiping={enableSwiping}
            enableHalfStar={enableHalfStar}
            animationConfig={{
                scale: 1,
                ...animationConfig,
            }}
            style={[ratingStyle.contStyle, ...styles]}
        />
    );
};

export default CustomRating;

const RatingStyle = () =>
    StyleSheet.create({
        starStyle: {
            marginLeft: 0,
            marginRight: 0,
            paddingRight: 0,
        },
        contStyle: {
            marginHorizontal: 0,
        },
    });
